// SettingDialog.cpp : implementation file
//

#include "stdafx.h"
#include "NetDecoder.h"
#include "SettingDialog.h"
#include "Include\CLS_NVDSDK_Interface.h"
#include "Include\CommonFun.h"
#include "DecCtrlClientTypes.h"

// CSettingDialog dialog

IMPLEMENT_DYNAMIC(CSettingDialog, CDialog)

CSettingDialog::CSettingDialog(CWnd* pParentWnd)
: CLS_CBasePage(CSettingDialog::IDD, pParentWnd)
{
	m_pCurrent = NULL;
}

CSettingDialog::~CSettingDialog()
{
}

void CSettingDialog::DoDataExchange(CDataExchange* pDX)
{
	CLS_CBasePage::DoDataExchange(pDX);
	DDX_Control(pDX, IDC_TAB_SETTING, m_TabSetting);
	DDX_Control(pDX, IDC_TREE_CONFIG, m_tvConfig);
}


BEGIN_MESSAGE_MAP(CSettingDialog, CLS_CBasePage)
	ON_NOTIFY(TCN_SELCHANGE, IDC_TAB_SETTING, &CSettingDialog::OnTcnSelchangeTabSetting)
	ON_BN_CLICKED(IDC_BUTTON_RESUME, &CSettingDialog::OnBnClickedButtonResume)
	ON_BN_CLICKED(IDC_BUTTON_QUIT, &CSettingDialog::OnBnClickedButtonQuit)
	ON_NOTIFY(TVN_SELCHANGED, IDC_TREE_CONFIG, &CSettingDialog::OnTvnSelchangedTreeConfig)
END_MESSAGE_MAP()


// CSettingDialog message handlers

void  CSettingDialog::LoadSurfaceResource()
{
    SetDlgItemText(IDC_BUTTON_QUIT, GetText(IDS_SETTING_CLOSE));
	SetDlgItemText(IDC_BUTTON_RESUME, GetText(IDS_SETTING_RESET));
}

enum CONFIG_PAGE_INDEX
{
	CONFIG_MIN = 0,
	CONFIG_SETTING_IP = CONFIG_MIN,
	CONFIG_SETTING_COM,
	CONFIG_SETTING_DDNS,
	CONFIG_SETTING_PROTOCOLTITLE,
	CONFIG_SETTING_MULI_SCREEN_TITLE,
	CONFIG_SETTING_PAGE_SET_TITLE,
	CONFIG_SETTING_PAGE_SHOW,
	CONFIG_SETTING_SYSTEMTITLE,
	CONFIG_SETTING_ALARMTITLE,
	CONFIG_SETTING_LOGO,
	CONFIG_SETTING_PLATFORMREG,
	CONFIG_SETTING_SIPTITLE,	
	CONFIG_SETTING_CUSTER,
	CONFIG_SETTING_LOG,
	CONFIG_SETTING_OSD,
	CONFIG_SETTING_POP_UP_WINDOW,	
	CONFIG_SETTING_CHANNEL_PARAM,
	CONFIG_SETTING_CHN_STATUS,
	CONFIG_SETTING_ABILITY_LEVEL,
	CONFIG_SETTING_ALARM_EFFECT,
	CONFIG_SETTING_LOOPITEM,
	CONFIG_SETTING_UDISK,
	CONFIG_MAX,
};


BOOL CSettingDialog::OnInitDialog()
{
	CLS_CBasePage::OnInitDialog();
    LoadSurfaceResource();

	m_pageSettingCuster.Initialize(m_lLogonID);

	//Ի
	m_pageSettingIP.Create(IDD_DIALOG_PAGE_SETTINGIP, this);
	m_pageSetting485.Create(IDD_DIALOG_PAGE_SETTING485, this);
	m_pageSettingAlarm.Create(IDD_DIALOG_PAGE_SETTINGALARM,this);
	m_pageSettingDDNS.Create(IDD_DIALOG_PAGE_SETTINGDDNS,this);
	m_pageSettingProtocol.Create(IDD_DIALOG_PAGE_SETTINGPROTOCOL,this);
	m_pageSettingPU.Create(IDD_DIALOG_PAGE_SETTINGPU, this);
	m_pageSettingLogo.Create(IDD_DIALOG_PAGE_SETTINGLOGO,this);
	m_pageSettingSystem.Create(IDD_DIALOG_PAGE_SETTINGSYSTEM,this);
	m_pageSettingSipAndPlatform.Create(IDD_DIALOG_PAGE_SIP,this);
	m_pageMultiScreen.Create(IDD_DIALOG_PAGE_TAB_SCREEN, this);
	m_pagePageSet.Create(IDD_DIALOG_PAGE_SET, this);
	m_pageSettingCuster.Create(IDD_DIALOG_PAGE_CUSTER, this);
	m_pageSettingLog.Create(IDD_DIALOG_PAGE_SETTINGSHOWLOG, this);
	m_pageSettingOCD.Create(IDD_DIALOG_PAGE_SETTING_OSD,  this);
	m_pageSettingPopUpWindow.Create(IDD_DIALOG_PAGE_SETTING_POP_UP_WINDOW, this);
	m_pageSettingOtherName.Create(IDD_DIALOG_PAGE_SETTING_CHANNEL_OTHER_NAME, this);
	m_pageSettingDevstatus.Create(IDD_DEVICE_STATUS, this);
	m_pageSettingAbilityLevel.Create(IDD_DIALOG_PAGE_SETTING_ABILITY_LEVEL, this);
	m_pageSettingShow.Create(IDD_DIALOG_PAGE_SETTING_SHOW, this);
	m_pageSettingAlarmEffect.Create(IDD_DIALOG_PAGE_SETTINGALARM_EFFECT,this);
	m_pageSettingLoopItem.Create(IDD_DIALOG_PAGE_SETTING_LOOPITEM,this);
	m_pageSettingUdisk.Create(IDD_DIALOG_PAGE_SETTING_UDISK,this);



	//豸ȡϢ
	m_pageSettingIP.Initialize(&m_decParam);
	m_pageSetting485.Initialize(&m_decParam);
	m_pageSettingAlarm.Initialize(&m_decParam);
	m_pageSettingDDNS.Initialize(&m_decParam);
	m_pageSettingProtocol.Initialize(&m_decParam);
	m_pageSettingPU.Initialize(&m_decParam);
	m_pageSettingLogo.Initialize(&m_decParam);
	m_pageSettingSystem.Initialize(&m_decParam);
	m_pageSettingSipAndPlatform.Initialize(m_lLogonID);
	m_pagePageSet.Initialize(&m_decParam);
	m_pageMultiScreen.Initialize(m_lLogonID);
	m_pageSettingCuster.Initialize(m_lLogonID);
	m_pageSettingLog.Initialize(&m_decParam);
	m_pageSettingOCD.Initialize();
	m_pageSettingPopUpWindow.Initialize(&m_decParam);
	m_pageSettingOtherName.Initialize(&m_decParam);
	m_pageSettingDevstatus.Initialize();
	m_pageSettingAlarmEffect.Initialize(&m_decParam);
	m_pageSettingLoopItem.Initialize();

	//趨TabʾķΧ
	CRect rc;
	m_TabSetting.GetClientRect(rc);
	rc.top += 21;
	rc.bottom -= 5;
	rc.left += 3;
	rc.right -= 5;
	//ʾʼҳ
	for (int i= 0 ; i < CONFIG_MAX ;i++)
	{
		if (m_pDialog[i] != NULL)
		{
			m_pDialog[i]->MoveWindow(&rc);
		}

	}

	this->SetWindowText(GetText(IDS_SETTING_SET));
	//浱ǰѡ
	m_iCurSelTab = 0;

	UI_UpdateDialog();

	return FALSE;  // return TRUE unless you set the focus to a control
	// EXCEPTION: OCX Property Pages should return FALSE
}

void CSettingDialog::OnTcnSelchangeTabSetting(NMHDR *pNMHDR, LRESULT *pResult)
{
// 	m_pDialog[m_iCurSelTab]->ShowWindow(SW_HIDE);
//     m_iCurSelTab = m_TabSetting.GetCurSel();
// 	m_pDialog[m_iCurSelTab]->ShowWindow(SW_SHOW);
	*pResult = 0;
}

int CSettingDialog::Initialize(LONG _lLogonID)
{
	if (_lLogonID < 0)
	{
		return -1;
	}
	//ѶԻָ뱣
	m_pDialog[CONFIG_SETTING_IP] = &m_pageSettingIP;
	m_pDialog[CONFIG_SETTING_COM] = &m_pageSetting485;
	m_pDialog[CONFIG_SETTING_DDNS] = &m_pageSettingDDNS;
	m_pDialog[CONFIG_SETTING_PROTOCOLTITLE] = &m_pageSettingProtocol;
	m_pDialog[CONFIG_SETTING_MULI_SCREEN_TITLE] = &m_pageMultiScreen;
	m_pDialog[CONFIG_SETTING_PAGE_SET_TITLE] = &m_pagePageSet;
	m_pDialog[CONFIG_SETTING_SYSTEMTITLE] = &m_pageSettingSystem;
	m_pDialog[CONFIG_SETTING_ALARMTITLE] = &m_pageSettingAlarm;
	m_pDialog[CONFIG_SETTING_LOGO] = &m_pageSettingLogo;
	m_pDialog[CONFIG_SETTING_PLATFORMREG] = &m_pageSettingPU;
	m_pDialog[CONFIG_SETTING_SIPTITLE] = &m_pageSettingSipAndPlatform;
	m_pDialog[CONFIG_SETTING_CUSTER] = &m_pageSettingCuster;
	m_pDialog[CONFIG_SETTING_LOG] = &m_pageSettingLog;
	m_pDialog[CONFIG_SETTING_OSD] = &m_pageSettingOCD;
	m_pDialog[CONFIG_SETTING_POP_UP_WINDOW] = &m_pageSettingPopUpWindow;
	m_pDialog[CONFIG_SETTING_CHANNEL_PARAM] = &m_pageSettingOtherName;
	m_pDialog[CONFIG_SETTING_CHN_STATUS] = &m_pageSettingDevstatus;
	m_pDialog[CONFIG_SETTING_ABILITY_LEVEL] = &m_pageSettingAbilityLevel;
	m_pDialog[CONFIG_SETTING_PAGE_SHOW] = &m_pageSettingShow;
	m_pDialog[CONFIG_SETTING_ALARM_EFFECT] = &m_pageSettingAlarmEffect;
	m_pDialog[CONFIG_SETTING_LOOPITEM] = &m_pageSettingLoopItem;
	m_pDialog[CONFIG_SETTING_UDISK] = &m_pageSettingUdisk;
	m_lLogonID = _lLogonID;

	memset(&m_decParam,0,sizeof(m_decParam));
	DEC_ClientGetDecoderPara(_lLogonID,&m_decParam);

	for (int i= 0 ; i < CONFIG_MAX ;i++)
	{
		if (m_pDialog[i] != NULL)
		{
			m_pDialog[i]->SetLogonID(m_lLogonID);
		}

	}
	return 0;
}

void CSettingDialog::OnBnClickedButtonResume()
{
	if (MessageBox(GetText(IDS_SETTING_RECOVER), _T(""), MB_OKCANCEL +MB_ICONQUESTION + MB_TOPMOST) == IDOK)
	{
		if(DEC_ClientResetDefault(m_lLogonID)==0)
		{
			EndDialog(0);
		}
	}
}

void CSettingDialog::OnBnClickedButtonQuit()
{
	EndDialog(0);
}

void CSettingDialog::RecvUpdateMsg()
{
    m_pageSettingLogo.RecvUpdateMsg();
	m_pageSettingProtocol.RecvUpdateMsg();
	m_pageSettingSystem.RecvUpdateMsg();
}

void CSettingDialog::UpdateLog(_MAIN_NOTIFY_DATA* _pData)
{
	m_pageSettingLog.OnMainNotify(_pData);
}

int CSettingDialog::ProgressNotify(int _iProgress)
{
    if (m_pageSettingLogo.m_dlgUpgrade.m_hWnd)
    {
		return m_pageSettingLogo.m_dlgUpgrade.ProgressNotify(_iProgress);
    }
	else if (m_pageSettingProtocol.m_dlgUpgrade.m_hWnd)
	{
		return m_pageSettingProtocol.m_dlgUpgrade.ProgressNotify(_iProgress);
	}
	else if (m_pageSettingSystem.m_dlgUpgrade.m_hWnd)
	{
		return m_pageSettingSystem.m_dlgUpgrade.ProgressNotify(_iProgress);
	}

	return -1;
}

void CSettingDialog::ChangeParamNotify(_CHANGE_PARAM_NOTIFY_DATA* _pData)
{
	for (int i= 0 ; i < CONFIG_MAX ;i++)
	{
		if (m_pDialog[i] != NULL)
		{
			m_pDialog[i]->OnParamChangeNotify(_pData);
		}

	}
}

int CSettingDialog::UpdateNotify(_MAIN_NOTIFY_DATA* _pData)
{
	
	int iType = _pData->m_iMsg;
	int iID = _pData->m_lID;
	switch(iType)
	{
	case DEC_WCM_DEC_UPGRADE: 
		{
			RecvUpdateMsg();
			int iStatus = _pData->tParam.iUpgradeState;
			if (iStatus == 0)
			{
				MessageBox(GetText(IDS_UPGRADE_SUCCESS_RELOGON), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
			}
			else
			{
				MessageBox(GetText(IDS_UPGRADE_FAIL), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
			}
			break;
		}
	case DEC_WCM_DEC_UPGRADEP:
		{
			RecvUpdateMsg();
			int iStatus = _pData->tParam.iUpgradeState;
			if (iStatus == 0)
			{
				MessageBox(GetText(IDS_UPGRADE_SUCCESS_RESTART), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
			}
			else
			{
				MessageBox(GetText(IDS_UPGRADE_FAIL), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
			}
			break;
		}
	case DEC_WCM_DEC_UPGRADELOGO:
	case DEC_WCM_DEC_UPGRADEWEB:
		{
			RecvUpdateMsg();
			int iStatus = _pData->tParam.iUpgradeState;
			if (iStatus == RET_UPGRADE_FINISH)//0
			{
				MessageBox(GetText(IDS_UPGRADE_SUCCESS), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
			}
			else if(iStatus == RET_UPGRADE_FAILED)//1
			{
                MessageBox(GetText(IDS_UPGRADE_FAIL),  _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
			}
			else if (iStatus == RET_UPGRADE_ERROR)//2
			{
				MessageBox(GetText(IDS_UPGRADE_ERROR),  _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
			}
			else
			{
				//TODO:nothing....
			}
			break;
		}
	case DEC_WCM_QUERY_LOG_FINISH:
		{
			UpdateLog(_pData);
			break;
		}
	case DEC_WCM_SEARCH_NVD:
	case DEC_WCM_SEARCH_IPC:
		{
			UpdateCluster(_pData);
			break;
		}
	case DEC_WCM_DEC_UPGRADEPROCESS:
		{
            ProgressNotify(_pData->tParam.iUpgradeProgress);
			break;
		}
	case DEC_WCM_EXPORT_CONFIG_FINISH:
		{
			MessageBox(GetText(IDS_EXPORT_SUCCESS), _T(""), MB_OK +MB_ICONINFORMATION + MB_TOPMOST);
			break;
		}

	case DEC_WCM_LOG_WRITE:
		{
			int iRet = _pData->tParam.iUserPassResult;
			CString strResult;
			strResult.Format("write log result %d", iRet);
			MessageBox(strResult,"",MB_OK|MB_TOPMOST);
			break;
		}
	case DEC_WCM_DEC_GETUDISK_VIDEOLISTS:
		m_pageSettingUdisk.OnMainNotify(_pData);
		break;
	default:
		for (int i= 0 ; i < CONFIG_MAX ;i++)
		{
			if (m_pDialog[i] != NULL)
			{
				m_pDialog[i]->OnMainNotify(_pData);
			}

		}
		break;
   
	}
	return 0;
}



void CSettingDialog::UpdateCluster( _MAIN_NOTIFY_DATA* _pData )
{
	m_pageSettingCuster.OnMainNotify(_pData);
}

void CSettingDialog::UI_UpdateDialog()
{	
	HTREEITEM hItem = NULL;
	HTREEITEM hSubItem = NULL;
	HTREEITEM hThirdItem = NULL;
	hItem = InsertItem(m_tvConfig,"IP",CONFIG_SETTING_IP);
	m_tvConfig.Select(hItem,TVGN_CARET);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_COM,CONFIG_SETTING_COM);
	hItem = InsertItem(m_tvConfig,"DDNS",CONFIG_SETTING_DDNS);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_PROTOCOLTITLE,CONFIG_SETTING_PROTOCOLTITLE);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_MULI_SCREEN_TITLE,CONFIG_SETTING_MULI_SCREEN_TITLE);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_PAGE_SET_TITLE,CONFIG_SETTING_PAGE_SET_TITLE);
	hItem = InsertItem(m_tvConfig,"ʾ",CONFIG_SETTING_PAGE_SHOW);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_SYSTEMTITLE,CONFIG_SETTING_SYSTEMTITLE);
	hItem = InsertItem(m_tvConfig,"Ԥ",CONFIG_SETTING_LOOPITEM);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_ALARMTITLE,CONFIG_SETTING_ALARMTITLE);
	hItem = InsertItem(m_tvConfig,"LOGO",CONFIG_SETTING_LOGO);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_PLATFORMREG,CONFIG_SETTING_PLATFORMREG);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_SIPTITLE,CONFIG_SETTING_SIPTITLE);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_CUSTER,CONFIG_SETTING_CUSTER);
	hItem = InsertItem(m_tvConfig,IDS_CFG_LOG_DVR_LOG,CONFIG_SETTING_LOG);
	hItem = InsertItem(m_tvConfig,IDS_CFG_LOG_DVR_OSD,CONFIG_SETTING_OSD);
	hItem = InsertItem(m_tvConfig,IDS_CFG_POP_UP_WINDOW,CONFIG_SETTING_POP_UP_WINDOW);
	hItem = InsertItem(m_tvConfig,IDS_CFG_CHANNEL_PARAM,CONFIG_SETTING_CHANNEL_PARAM);
	hItem = InsertItem(m_tvConfig,IDS_CFG_CHN_STATUS,CONFIG_SETTING_CHN_STATUS);
	hItem = InsertItem(m_tvConfig,"",CONFIG_SETTING_ABILITY_LEVEL);
	hItem = InsertItem(m_tvConfig,IDS_SETTING_ALARM_EFFECT,CONFIG_SETTING_ALARM_EFFECT);
	hItem = InsertItem(m_tvConfig,GetTextByLan("U","UDisk"),CONFIG_SETTING_UDISK);

	ShowBasePage(0);
}

void CSettingDialog::OnTvnSelchangedTreeConfig(NMHDR *pNMHDR, LRESULT *pResult)
{
	LPNMTREEVIEW pNMTreeView = reinterpret_cast<LPNMTREEVIEW>(pNMHDR);
	// TODO: Add your control notification handler code here
	HTREEITEM hItem = pNMTreeView->itemNew.hItem;
	int iIndex = m_tvConfig.GetItemData(hItem);
	ShowBasePage(iIndex);

	*pResult = 0;
}

int CSettingDialog::ShowBasePage( int _iIndex )
{
	if (_iIndex < CONFIG_MIN || _iIndex >= CONFIG_MAX)
	{
		return -1;
	}

	if (m_pDialog[_iIndex] == NULL)
	{
		return -1;
	}

	RECT rcShow = {0};
	GetDlgItem(IDC_STATIC_CENTER_BG)->GetWindowRect(&rcShow);
	ScreenToClient(&rcShow);
	m_pDialog[_iIndex]->MoveWindow(&rcShow);

	if(m_pCurrent)
	{
		m_pCurrent->ShowWindow(SW_HIDE);
	}
	m_pCurrent = m_pDialog[_iIndex];
	m_pCurrent->ShowWindow(SW_SHOW);
	return 0;
}
